/*
 * @(#)EventDispatcher.java  1.1  2001-08-24
 *
 * Copyright (c) 2001 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.gui.event;

import ch.randelshofer.util.EventLoop;
import java.awt.ActiveEvent;

/**
 * Processes java.awt.ActiveEvent's on a background thread.
 * <p>
 * <b>Example</b>
 * <br>This writes Hello World on the background thread
 * of the EventDispatcher:
 * <pre><tt>
 * ActiveEvent event = new ActiveEvent() {
 *     public void dispatch() {
 *          System.out.println("Hello World");
 *     }
 * };
 * 
 * EventDispatcher dispatcher = new EventDispatcher();
 * dispatcher.dispatch(event);
 * </tt></pre>
 *
 * @author Werner Randelshofer
 * @version 1.1 2001-08-24 Reworked for JDK 1.3.
 * <br>1.0 1998-10-07 Created.
 */
public class EventDispatcher
extends EventLoop {
  /**
   * Creates a new event dispatcher which dispatches events at Thread.NORM_PRIORITY.
   */
  public EventDispatcher() {
    super();
    }
    /**
     * Creates a new EventDispatcher which processes events at the 
     * desired thread priority.
     *
     * @param priority The Thread priority of the event processor.
     */
    public EventDispatcher(int threadPriority) {
        super(threadPriority);
    }
    /**
     * Calls the #dispatch method of the ActiveEvent.
     * 
     * @param event An instance of java.awt.ActiveEvent.
     */
    protected void processEvent(Object event) {
        ((ActiveEvent) event).dispatch();
    }

    /**
     * Collects an event for later processing.
     */
    public void dispatch(ActiveEvent event) {
        collectEvent(event);
    }
}